/*
* Copyright (C) 2008  Intel Corporation
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License, version 2.1, as published by the Free Software Foundation.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifdef WIN32
#include <afxwin.h>
#include <windows.h>
#endif
#include <stdio.h>              
#include <stdlib.h>             
#include <stddef.h>             
#include <string.h>             
#include <signal.h>             
#include "AccelApi.h"
#include "DCSApi.h"

#ifndef _WIN32
#define Sleep sleep
#endif

CHAR gravity;
int centerX=0;
int centerY=0;

void DCS_ReturnValue_handler(int ret)
{
	switch (ret)
	{
	case DCS_SUCCESS :
		printf("success\n");
		break;
	case DCS_NOT_SUPPORTED :
		printf("request is not supported\n");
		break;
	case DCS_REQUEST_DENIED:
		printf("request is denied\n");
		break;
	case DCS_MODULE_NOTEXIST:
		printf("request module does not exit\n");
		break;
	case DCS_EVENT_NOTEXIST:
		printf("request event does not exit\n");
		break;
	case DCS_FUNC_NOTEXIST:
		printf("request function does not exit\n");
		break;
	case DCS_FAIL_OPERATION:
		printf("operation failed\n");
		break;
	case DCS_CONNECTION_ABORT:
		printf("connection abort\n");
	default:
		break;
	}
}


/* Call back function for Accelerometer*/
void CALLBACK  DCS_Accel_handler (PDCS_Accel_Data  pData)
{
	if (pData == NULL) 
		return;

	printf("accel data: (%d, %d, %d) \n", pData->AccelX,pData->AccelY,pData->AccelZ);

	if (pData->AccelX > (centerX + gravity/3)) 
	{
		printf("X axis is toward to RIGHT direction\n");
	}
	else if (pData->AccelX < (centerX - gravity/3)) 
	{
		printf("X axis is toward to LEFT direction\n");
	} 

	if (pData->AccelY > (centerY + gravity/3)) 
	{
		printf("Y axis is toward to UP direction\n");
	}
	else if (pData->AccelY < (centerY - gravity/3)) 
	{
		printf("Y axis is toward to DOWN direction\n");
	} 
}

int main(int argc, char *argv[])
{
	int ret = 0;
	int i=0;
	int use_timer=0;
	char c0;

	/* Command line parsing */
	for (i=1; i< argc; i++) 
	{
		if (strcmp("-timer", argv[i]) == 0  )
		{
			use_timer=1;
		}
	}

	/*initialize the DCS*/
	ret = DCS_Initialize();

	DCS_ReturnValue_handler( ret);

	/*	For the Accelerometer Interface	*/
	DCS_Accel_Data data;

	ret=DCS_RegisterAccelCallback( DCS_Accel_handler);
	printf("DCS_RegisterAccelCallback\n");
	DCS_ReturnValue_handler(ret);

	ret=DCS_GetAccelForGravity(&gravity);
	printf("DCS_GetAccelForGravity\n");
	DCS_ReturnValue_handler( ret);

	printf(" gravity:%d\n", gravity);
	int count=0;
	int timer=0;

	if(use_timer==0)
	{
		//Sleep(INFINITE);
		
		while(1) 
		    Sleep(10);
	}else{
		for(timer=0;timer<=50000;timer++)
		{
			count=0;
		
			Sleep(10);
		}
	}

	return 0;
}

